<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

require_once 'connect.php';

try {
    $conn = getDatabaseConnection();
    $blog_id = $_GET['blog_id'] ?? '';

    if (empty($blog_id)) {
        throw new Exception("Blog ID is required", 400);
    }

    $query = "SELECT c.id, c.name 
              FROM categories c
              JOIN categories_blog bc ON c.id = bc.category_id 
              WHERE bc.blog_id = :blog_id 
              ORDER BY c.name ASC"; 
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':blog_id', $blog_id, PDO::PARAM_INT);
    $stmt->execute();

    $categories = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $categories[] = [
            'id' => (int)$row['id'], 
            'name' => $row['name']
        ];
    }

    echo json_encode([
        "success" => true,
        "data" => $categories
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        "success" => false,
        "message" => "Failed to fetch blog categories: " . $e->getMessage()
    ]);
} catch (Exception $e) {
    http_response_code($e->getCode() ?: 400);
    echo json_encode([
        "success" => false,
        "message" => $e->getMessage()
    ]);
}
?>