<?php
session_start();
require_once 'connect.php';

function login($username, $password) {
    try {
        $conn = getDatabaseConnection();
        $stmt = $conn->prepare("SELECT id, password_hash FROM user WHERE username = :username LIMIT 1");
        $stmt->bindParam(':username', $username);
        $stmt->execute();
        
        $writer = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($writer && password_verify($password, $writer['password_hash'])) {
            $_SESSION['user_id'] = $writer['id'];
            $_SESSION['authenticated'] = true;
            return true;
        }
        return false;
    } catch (PDOException $e) {
        error_log("Login error: " . $e->getMessage());
        return false;
    }
}

function isAuthenticated() {
    return isset($_SESSION['authenticated']) && $_SESSION['authenticated'] === true;
}

function logout() {
    session_unset();
    session_destroy();
}

function requireAuth() {
    if (!isAuthenticated()) {
        header('HTTP/1.1 401 Unauthorized');
        exit('Unauthorized access');
    }
}