<?php
require_once 'connect.php';
try {
    // Get database connection
    $conn = getDatabaseConnection();

    // Get all active subscribers with their details
    $stmt = $conn->query("
        SELECT id, email, subscribed_at, is_active 
        FROM subscribers 
        WHERE is_active = 1
        ORDER BY subscribed_at DESC
    ");
    
    $subscribers = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($subscribers)) {
        echo json_encode([
            'success' => true,
            'message' => 'No active subscribers found',
            'count' => 0,
            'subscribers' => []
        ]);
        exit;
    }

    echo json_encode([
        'success' => true,
        'count' => count($subscribers),
        'subscribers' => $subscribers
    ]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?>
    
