<?php
require_once 'connect.php';

try {
    $conn = getDatabaseConnection();

    $query = "SELECT 
    
            c.id, 
            c.name, 
            SUM(CASE WHEN b.id IS NOT NULL AND b.status = 'active' THEN 1 ELSE 0 END) as blog_count
          FROM categories c
          LEFT JOIN blogs b ON c.id = b.category
          GROUP BY c.id, c.name
          ORDER BY c.name";

    $stmt = $conn->prepare($query);
    $stmt->execute();

    $categories = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $categories[] = [
            'id' => (int) $row['id'],
            'name' => $row['name'],
            'blog_count' => (int) $row['blog_count'],
        ];
    }

    http_response_code(200);
    echo json_encode([
        'success' => true,
        'data' => $categories,
        'count' => count($categories),
    ]);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Failed to fetch categories',
        'error' => $e->getMessage(),
    ]);
}
?>
