<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

require_once 'connect.php';

try {
    $conn = getDatabaseConnection();
    $input = json_decode(file_get_contents('php://input'), true);
    $method = $_SERVER['REQUEST_METHOD'];

    if (!isset($input['id']) && !isset($_GET['id'])) {
        throw new Exception('Subscriber ID is required');
    }
    $subscriberId = isset($input['id']) ? (int)$input['id'] : (int)$_GET['id'];

    $stmt = $conn->prepare(
        'SELECT id, email, is_active FROM subscribers WHERE id = ?'
    );
    $stmt->execute([$subscriberId]);
    $subscriber = $stmt->fetch();

    if (!$subscriber) {
        throw new Exception('Subscriber not found');
    }

    if ($method === 'GET') {
        echo json_encode([
            'success' => true,
            'message' => 'Subscriber found',
            'email' => $subscriber['email'],
            'is_active' => (bool) $subscriber['is_active'],
            'subscriber_id' => $subscriberId 
        ]);
    } elseif (
        $method === 'POST' &&
        isset($input['confirm']) &&
        $input['confirm'] === true
    ) {
        if ($subscriber['is_active'] == 0) {
            echo json_encode([
                'success' => true,
                'message' =>
                'You have already been unsubscribed from our newsletters.',
                'email' => $subscriber['email'],
            ]);
        } else {
            $updateStmt = $conn->prepare(
                'UPDATE subscribers SET is_active = 0 WHERE id = ?'
            );
            $updateStmt->execute([$subscriberId]);

            echo json_encode([
                'success' => true,
                'message' =>
                'You have been successfully unsubscribed from our newsletters.',
                'email' => $subscriber['email'],
            ]);
        }
    } else {
        throw new Exception('There was an error !');
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage(),
    ]);
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
    ]);
}
