<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

require_once 'connect.php';
require __DIR__ . '/../vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

$WEBSITE_URL = 'https://digifunzi.com';
function getFirstWords($content, $wordCount = 300)
{

    $plainText = strip_tags($content);

    $words = preg_split('/\s+/', $plainText);

    $firstWords = array_slice($words, 0, $wordCount);
    return implode(' ', $firstWords) . '...';
}

try {
    $conn = getDatabaseConnection();
    $input = json_decode(file_get_contents('php://input'), true);

    if (!isset($input['blog_id'])) {
        throw new Exception('Blog ID is required');
    }

    $blogId = (int) $input['blog_id'];
    $customMessage = $input['custom_message'] ?? '';

    $conn->beginTransaction();

    try {
        $stmt = $conn->prepare("
    SELECT b.id, b.title, b.content, b.cover_image, b.created_at, c.name AS category_name
    FROM blogs b
    LEFT JOIN categories c ON b.category = c.id
    WHERE b.id = ?
");

        $stmt->execute([$blogId]);
        $blog = $stmt->fetch();

        if (!$blog) {
            throw new Exception("Blog post not found (ID: $blogId)");
        }
        $excerpt = getFirstWords($blog['content'], 300);
        $categoryName = $blog['category_name'] ?? 'Uncategorized';
        $subject = "{$blog['title']}";
        $formattedDate = date('M j, Y', strtotime($blog['created_at']));
        $message = $customMessage;

        $stmt = $conn->prepare(
            'INSERT INTO notifications (blog_id, subject, message) VALUES (?, ?, ?)'
        );
        $stmt->execute([$blogId, $subject, $message]);
        $notificationId = $conn->lastInsertId();

        $stmt = $conn->prepare(
            'SELECT id, email FROM subscribers WHERE is_active = 1'
        );
        $stmt->execute();
        $subscribers = $stmt->fetchAll();

        if (empty($subscribers)) {
            throw new Exception('No active subscribers found');
        }

        $sentCount = 0;
        $failedEmails = [];
        $stmt = $conn->prepare("INSERT INTO notification_recipients (notification_id, subscriber_id, sent_status) VALUES (?, ?, ?)");


        foreach ($subscribers as $subscriber) {
            try {
                $mail = new PHPMailer(true);

                // Server settings
                $mail->SMTPDebug = SMTP::DEBUG_SERVER; // Enable verbose debug output
                $mail->isSMTP(); // Send using SMTP
                $mail->Host = 'digifunzi.com'; // Set the SMTP server to send through
                $mail->SMTPAuth = true; // Enable SMTP authentication
                $mail->Username = 'support@digifunzi.com'; // SMTP username
                $mail->Password = 'ZS4nGyfzf(aj'; // SMTP password
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // Enable implicit TLS encryption
                $mail->Port = 465;
                $email = trim($subscriber['email']);
                $mail->addAddress($email);

                // TCP port to connect to

                // Recipients
                $mail->setFrom('support@digifunzi.com', 'Digifunzi');
                $mail->addReplyTo('support@digifunzi.com', 'Information');

                // Content
                $mail->isHTML(true);
                $mail->Subject = $subject;

                $mail->Body = <<<EOD

                    <!DOCTYPE html>
                <html>
                <head>
                <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
                        <meta name="viewport" content="width=device-width, initial-scale=1">
                        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
                         <meta name="keywords" content="Digifunzi, digital skills education, robotics for kids, AI for kids, coding for kids, STEM education, digital literacy programs, future skills for children, school technology programs, learn robotics AI coding, {$categoryName}, {$blog['title']}" />
                                        <meta name="description" content="{$excerpt}" />
                                        <style type="text/css">
                                        body { font-family: Comfortaa; margin: 0; padding: 0; }
                                        .container { max-width: 650px; margin: 0 auto; padding: 20px; }
                                        .card { border: 1px solid #C0C0C0; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); background: #fff; padding: 25px; }
                                        .blog-image img { 
                                            width: 100%; 
                                            max-width: 600px; 
                                            height: 300px; 
                                            object-fit: cover; 
                                            display: block; 
                                            border-radius: 8px; 
                                            margin-bottom: 15px; 
                                        }
                                        .blog-title { font-size: 24px; color: #000; margin: 10px 0; }
                                        .blog-info { font-size: 14px; color: #666; margin-bottom: 15px; display:flex; }
                                        .blog-info .post-author img { 
                                            width: 50px; 
                                            height: 50px; 
                                            vertical-align: middle; 
                                            margin-right: 5px; 
                                            object-fit: contain; 
                                        }
                                        .blog-info .post-author span { vertical-align: middle;  margin-left: 15px;  }
                                        .blog-content { font-size: 14px; line-height: 1.6; color: #444; margin-bottom: 20px; }
                                        .btn { text-align: center; }
                                        .button {
                                            display: inline-block; 
                                            padding: 12px 24px; 
                                            background-color: #38aae1;
                                            color: white !important; 
                                            text-decoration: none; 
                                            border-radius: 4px;
                                            font-weight: bold; 
                                            margin: 15px 0; 
                                            text-align: center;
                                        }
                                        .blog-header {
                                            background-color: #38aae1; 
                                            color: #ffffff; 
                                            padding: 20px 30px;
                                            display: flex;
                                            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1); 
                                            margin-bottom: 20px;
                                        }
                                        .blog-logo {
                                            display: flex;
                                            justify-content: center;
                                            margin: 10px 0; 
                                        }
                                        .header-logo {
                                            width: 50px; 
                                            height: 50px; 
                                            object-fit: contain; 
                                        }
                                        .footer { 
                                            margin-top: 30px; 
                                            padding-top: 20px; 
                                            border-top: 1px solid #eee; 
                                            font-size: 12px; 
                                            color: #777; 
                                            text-align: center; 
                                        }
                                        .logo { 
                                            max-width: 300px; 
                                            max-height: 200px; 
                                            margin-bottom: 5px; 
                                        }
                                        .social-links a { 
                                            margin: 0 10px; 
                                            color: #0d6efd; 
                                            text-decoration: none; 
                                        }
                                        @media (max-width: 600px) {
                                            .container { padding: 10px; }
                                            .card { padding: 15px; }
                                            .blog-title { font-size: 20px; }
                                            .blog-info { font-size: 12px; }
                                            .blog-image img { 
                                                max-width: 100%; 
                                                height: 200px; 
                                            }
                                            .header-logo { 
                                                width: 40px; 
                                                height: 40px; 
                                            }
                                            .blog-info .post-author img { 
                                                width: 40px; 
                                                height: 40px; 
                                            }
                                            .logo { 
                                                max-width: 100px; 
                                                max-height: 100px; 
                                                margin-bottom: 5px; 
                                            }
                                        }
                                    </style>
                </head>
                <body>
                    <div class='container'>
                        <div class='card'>
                            <div class='blog-header'>
                                <h2 class='blog-info'>We are Excited to Share with you our new blog!</h2>
                            </div>
                            <div class='blog-logo'>
                                <img src='https://app.digifunzi.com/assets/img/digifunzi-transparent.png' alt='DigiFunzi logo' class='header-logo'>
                            </div>
                            <h3 class='blog-title'> s{$blog['title']}</h3>
                            <div class='blog-image'>
                                <img src='{$blog['cover_image']}' alt='{$blog['title']}' class='img-fluid'  onload='console.log("Blog cover image loaded: {$blog['cover_image']}")'
                    onerror='console.log("Blog cover image failed: {$blog['cover_image']}")'>
                            </div>
                            <div class='blog-info'>
                                <div class='post-author'>
                                    <img src='https://app.digifunzi.com/assets/img/digifunzi-transparent.png' alt='Logo'>
                                    <span>Digifunzi</span>
                                </div>
                                <span> | {$formattedDate}</span>
                            </div>
                            <div class='blog-content'>{$excerpt}</div>
                            <div class='btn'>
                                <a href='{$WEBSITE_URL}/blog/{$blog['id']}' class='button'>Read Full Article</a>
                            </div>
                        </div>
                        <div class='footer'>
                            <p>You received this email because you subscribed to DigiFunzi updates</p>
                           <!-- <p><a href='http://localhost:3000/unsubscribe/{$subscriber['id']}'>Unsubscribe</a></p>-->  
                         <p><a href='{$WEBSITE_URL}/unsubscribe/{$subscriber['id']}'>Unsubscribe</a></p>                       
                          <img src='https://app.digifunzi.com/assets/images/digifunzi-web-banner.png' alt='DigiFunzi' class='logo'>
                            <div class='social-links'>
                                <a href='https://www.facebook.com/digifunzi'>Facebook</a> | 
                                <a href='https://www.linkedin.com/company/digifunzi/'>LinkedIn</a> | 
                                <a href='https://www.instagram.com/digifunzi/'>Instagram</a>
                            </div>
                            <p>© 2025. DigiFunzi. All rights reserved.</p>
                        </div>
                    </div>
                </body>
                </html>
                EOD;

                $mail->SMTPDebug = 0;
                $mail->send();
                $sentCount++;
            } catch (Exception $e) {
                $failedEmails[] = [
                    'email' => $subscriber['email'],
                    'error' => $mail->ErrorInfo,
                ];
            }
        }

        $conn->commit();

        echo json_encode([
            'success' => true,
            'message' => 'Newsletter sent successfully',
            'notification_id' => $notificationId,
            'recipient_count' => count($subscribers),
            'sent_count' => $sentCount,
            'failed_count' => count($failedEmails),
            'failed_emails' => $failedEmails,
            'blog_title' => $blog['title'],
        ]);
    } catch (Exception $e) {
        $conn->rollBack();
        throw $e;
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage(),
    ]);
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}

