<?php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
require_once 'connect.php';
require_once 'auth.php';

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

try {

    $jsonInput = file_get_contents('php://input');
    $data = json_decode($jsonInput, true);
    
 
    if ($jsonInput === false || $data === null) {
        throw new Exception(
            "Invalid JSON: " . json_last_error_msg(),
            400
        );
    }

    // Validate fields
    if (empty($data['username']) || empty($data['password'])) {
        throw new Exception("Username and password are required", 400);
    }

    //  login
    if (login($data['username'], $data['password'])) {
        echo json_encode([
            'success' => true,
            'message' => 'Login successful',
            'session_id' => session_id()
        ]);
    } else {
        throw new Exception("Invalid credentials", 401);
    }

} catch (Exception $e) {
    http_response_code($e->getCode() ?: 500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
        'error_code' => $e->getCode()
    ]);
    error_log("Login error: " . $e->getMessage());
}