<?php
require_once 'connect.php';

try {
    $conn = getDatabaseConnection();

    $id = $_GET['id'] ?? null;
    
    if (!$id) {
        http_response_code(400);
        echo json_encode(["error" => "Blog ID is required"]);
        exit;
    }
    
    $stmt = $conn->prepare("SELECT * FROM blogs WHERE id = :id");
    $stmt->bindParam(':id', $id);
    $stmt->execute();
    
    $blog = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($blog) {
        // Format the image URL
        $base_url = "http://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['SCRIPT_NAME']);
        if (!empty($blog['cover_image'])) {
            $blog['cover_image'] = $base_url . '/uploads/' . rawurlencode(basename($blog['cover_image']));
        }
        echo json_encode($blog);
    } else {
        http_response_code(404);
        echo json_encode(["error" => "Blog not found"]);
    }
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode(["error" => "Database error: " . $e->getMessage()]);
}
?>