<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

require_once 'connect.php';

try {
    $conn = getDatabaseConnection();

    $limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 10;
    $offset = isset($_GET['offset']) ? (int)$_GET['offset'] : 0;
    
    // Fetch active blogs
    $stmt = $conn->prepare("SELECT * FROM blogs WHERE status = 'active' ORDER BY created_at DESC LIMIT :limit OFFSET :offset");
    $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
    $stmt->bindParam(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();
    
    $blogs = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Check if more blogs
    $totalStmt = $conn->prepare("SELECT COUNT(*) as total FROM blogs WHERE status = 'active'");
    $totalStmt->execute();
    $totalBlogs = $totalStmt->fetch(PDO::FETCH_ASSOC)['total'];
    
    $hasMore = ($offset + count($blogs)) < $totalBlogs;
    
    // Format image URLs
    $base_url = "http://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['SCRIPT_NAME']);
    
    foreach ($blogs as &$blog) {
        if (!empty($blog['cover_image'])) {
            $filename = basename($blog['cover_image']);
            $blog['cover_image'] = $base_url . '/uploads/' . rawurlencode($filename);
        }
    }
    unset($blog); 
    
    echo json_encode([
        'blogs' => $blogs,
        'hasMore' => $hasMore,
        
    ]);
    
} catch(PDOException $e) {
    http_response_code(500);
    echo json_encode(["error" => "Database error: " . $e->getMessage()]);
}