<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Credentials: true');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

require_once 'connect.php';

try {
    $conn = getDatabaseConnection();

    $id = $_POST['id'] ?? null;

    if (!$id) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'Blog ID is required',
        ]);
        exit();
    }

    $title = $_POST['title'] ?? '';
    $content = $_POST['content'] ?? '';
    $default_category = $_POST['category'] ?? '';  
    $categories = isset($_POST['categories']) ? json_decode($_POST['categories'], true) : [];
    $blog_type = $_POST['blog_type'] ?? '';
    $status = $_POST['status'] ?? '';
    $tags = isset($_POST['tags']) ? json_decode($_POST['tags'], true) : [];

    if (empty($title) || empty($category_id) || empty($blog_type) || empty($status)) {
        throw new Exception("Required fields are missing", 400);
    }
   //add image
    $currentQuery = "SELECT cover_image FROM blogs WHERE id = :id";
    $currentStmt = $conn->prepare($currentQuery);
    $currentStmt->bindParam(':id', $id, PDO::PARAM_INT);
    $currentStmt->execute();
    $current_cover = $currentStmt->fetchColumn();

    $cover_image = $current_cover;
    if (!empty($_FILES['cover_image']['name']) && $_FILES['cover_image']['error'] === UPLOAD_ERR_OK) {
        $target_dir = 'uploads/';
        if (!file_exists($target_dir)) {
            if (!mkdir($target_dir, 0755, true)) {
                throw new Exception("Failed to create uploads directory");
            }
        }
        $filename = time() . '_' . basename($_FILES['cover_image']['name']);
        $target_file = $target_dir . $filename;

   
        $allowed_types = ['image/jpeg', 'image/png', 'image/gif'];
        $file_type = mime_content_type($_FILES['cover_image']['tmp_name']);
        if (!in_array($file_type, $allowed_types)) {
            throw new Exception("Invalid file type. Only JPG, PNG, and GIF are allowed.");
        }

        if (!move_uploaded_file($_FILES['cover_image']['tmp_name'], $target_file)) {
            throw new Exception("File upload failed");
        }
        $cover_image = $filename;

        // Delete old cover image if exists and different
        if ($current_cover && $current_cover !== $filename && file_exists($target_dir . $current_cover)) {
            unlink($target_dir . $current_cover);
        }
    } 

    $conn->beginTransaction();

   
    $query = "UPDATE blogs SET 
                title = :title,
                content = :content,
                category = :default_category,
                blog_type = :blog_type,
                cover_image = :cover_image,
                status = :status
              WHERE id = :id";

    $stmt = $conn->prepare($query);
    $stmt->bindParam(':title', $title);
    $stmt->bindParam(':content', $content);
    $stmt->bindParam(':default_category', $default_category, PDO::PARAM_INT);
    $stmt->bindParam(':blog_type', $blog_type);
    $stmt->bindParam(':cover_image', $cover_image);
    $stmt->bindParam(':status', $status);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    if (!$stmt->execute()) {
        throw new Exception("Failed to update blog post");
    }

    // Update tags if provided
    if (isset($_POST['tags'])) {
        $deleteStmt = $conn->prepare('DELETE FROM blog_tags WHERE blog_id = :blog_id');
        $deleteStmt->bindParam(':blog_id', $id, PDO::PARAM_INT);
        $deleteStmt->execute();

        if (is_array($tags) && count($tags) > 0) {
            $placeholders = [];
            $values = [];
            foreach ($tags as $tag_id) {
                $placeholders[] = '(?, ?)';
                $values[] = $id;
                $values[] = $tag_id;
            }
            $insertQuery = "INSERT INTO blog_tags (blog_id, tag_id) VALUES " . implode(', ', $placeholders);
            $insertStmt = $conn->prepare($insertQuery);
            if (!$insertStmt->execute($values)) {
                throw new Exception("Failed to update tags");
            }
        }
    }
    if (isset($_POST['categories'])) {
        $deleteStmt = $conn->prepare('DELETE FROM categories_blog WHERE blog_id = :blog_id');
        $deleteStmt->bindParam(':blog_id', $id, PDO::PARAM_INT);
        $deleteStmt->execute();

        if (is_array($categories) && count($categories) > 0) {
            $placeholders = [];
            $values       = [];
            foreach ($categories as $category_id) {
                $placeholders[] = '(?, ?)';
                $values[]       = $id;
                $values[]       = $category_id;
            }
            $insertQuery = "INSERT INTO categories_blog (blog_id, category_id) VALUES " . implode(', ', $placeholders);
            $insertStmt  = $conn->prepare($insertQuery);
             if (!$insertStmt->execute($values)) {
                throw new Exception("Failed to update categories");
            }
        }
    }

    $conn->commit();

    echo json_encode([
        'success' => true,
        'message' => 'Blog updated successfully',
        'blog_id' => $id,
        'cover_image' => $cover_image 
    ]);

} catch (PDOException $e) {
    if (isset($conn)) $conn->rollBack();
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage(),
        'error_details' => $e->getTraceAsString(),
    ]);
} catch (Exception $e) {
    if (isset($conn)) $conn->rollBack();
    http_response_code($e->getCode() ?: 400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage(),
    ]);
}