<?php
require_once 'connect.php';

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

$input = file_get_contents('php://input');
if (empty($input)) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'No data received',
        'received' => $input,
    ]);
    exit();
}

$data = json_decode($input, true);

// Email validation
if (!isset($data['email']) || empty(trim($data['email']))) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Email is required',
    ]);
    exit();
}

$email = trim($data['email']);

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Invalid email format',
    ]);
    exit();
}

try {
    $conn = getDatabaseConnection();
    $stmt = $conn->prepare(
        'SELECT * FROM subscribers WHERE email = ?'
    );
    $stmt->execute([$email]);
    if ($stmt->rowCount() > 0) {
        echo json_encode([
            'success' => true,
            'message' => "You're already subscribed!",
        ]);
       
    }else {
    // new sub
    $insert = $conn->prepare(
        'INSERT INTO subscribers (email, subscribed_at, is_active) VALUES (?, NOW(), 1)'
    );
    $insert->execute([$email]);

    echo json_encode([
        'success' => true,
        'message' => 'Thank you for subscribing!',
    ]);
}
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database error occurred',
        'error' => $e->getMessage(),
    ]);
}
?>
